<?php
/**
Das Script mappt eine URL auf eine Json-Struktur und läd sie als Webseite. 
Nicht vorhandene Seiten-URIs werden automatisch als neue Seiten angelegt, 
sofern das Attribut 'autocreate' in der Json auf 'true' steht. Zudem werden
zusätzliche Anfragen des Browsers nicht in neue Seiten übersetzt und müssen
daher ausgeschlossen werden.
Autor: Oliver Lohse
Datum: 23.01.2026
*/

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// Asset-Ordner und Dateie-Endungen ausschließen (Apache soll direkt ausliefern)
if (preg_match('#^/(templates|assets|css|js|images)/#', $uri)) {return false;}
if (preg_match('#\.(css|js|png|jpg|jpeg|gif|svg|ico|php)$#i', $uri)) {return false;}

$data = json_decode(file_get_contents('content.json'), true);
$uri = str_replace('/index.php', '', $uri);
$uri = trim($uri, '/');
$segments = $uri === '' ? [] : explode('/', $uri);

/**
Rekursive Seitenauflösung anhand der Umwandlung der URI in eine Array-Struktur.
*/
function resolvePage(array $pages, array $segments)
{
    if (empty($segments)) {
        return $pages['home'] ?? null;
    }

    $current = $pages['home'] ?? null;

    foreach ($segments as $segment) {
        if (!isset($current['children'][$segment])) {
            return null;
        }
        $current = $current['children'][$segment];
    }

    return $current;
}

/**
Rekursives Anlegen einer fehlenden Seite oder einer fehlenden Unterseite.
*/
function createPagePath(array &$pages, array $segments)
{
    $current =& $pages['home'];

    foreach ($segments as $segment) {

        if (!isset($current['children'])) {
            $current['children'] = [];
        }

        if (!isset($current['children'][$segment])) {
            $current['children'][$segment] = [
                'title'       => ucfirst(str_replace('-', ' ', $segment)),
                'template'    => 'default.php',
                'logo'        => '/img/logo.svg',
                'description' => 'Diese Seite wurde automatisch erstellt.',
                'content'     => 'Diese Seite wurde automatisch erstellt.',
                'children'    => []
            ];
        }

        $current =& $current['children'][$segment];
    }
}

// -------------------------------------------------
// Seite auflösen oder anlegen
// -------------------------------------------------
$page = resolvePage($data['pages'], $segments);

if ($page === null) 
{
    if($data['config']['autocreate'])
    {
        createPagePath($data['pages'], $segments);
        echo '<div class="bg-success p-4 text-light">Neue Seite wurde gespeichert.</div>';
        file_put_contents('content.json', json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE), LOCK_EX);
        $page = resolvePage($data['pages'], $segments);
    }

    //$page = resolvePage($data['pages'], $segments);
}

// -------------------------------------------------
// Template laden
// -------------------------------------------------
if ($page === null) {
    http_response_code(404);
    $page = [
        'title'       => '404 - Seite nicht gefunden',
        'description' => 'Die Seite existiert nicht oder die URL kann nicht aufgelöst werden.',
        'content'     => 'Die angeforderte Seite existiert nicht oder der angeforderte Request kann vom Server nicht aufgelöst werden.',
        'template'    => 'default.php'
    ];
    include('templates/' . $page['template']); 
} else {
    include('templates/' . $page['template']);
}
